package w83b.xml.parser;

import java.io.Serializable;
import java.text.ParseException;
//import java.util.logging.Logger;

import w83b.w83bUtilidadesComunes.W83bLocaleString;
import w83b.w83bUtilidadesComunes.W83bLocaleStringXML;
import w83b.w83bUtilidadesComunes.W83bUtilXml;
import w83b.w83bUtilidadesComunes.W83bException;
import w83b.xml.W83bXmlDocument;
import w83b.xml.W83bXmlElement;
import w83b.xml.datatype.W83bConsultationContext;
import w83b.xml.exception.W83bXmlException;



public class W83bConsultationContextParser implements Serializable {

	private static final long serialVersionUID = 1L;

	public W83bConsultationContextParser(String xmlConstultationContext)
			throws W83bXmlException, W83bException, ParseException {
		xmlDocument = new W83bXmlDocument();
		try {
			xmlDocument.createFromUtf8StringText(xmlConstultationContext);
		} catch (Exception e) {
			xmlDocument.createFromStringText(xmlConstultationContext);
		}
	}

	public W83bConsultationContextParser() {

	}

	public W83bConsultationContext getProcedureData() throws W83bException,
			W83bXmlException, ParseException {
		W83bXmlElement root = xmlDocument.getRootElement();
/*		W83bXmlElement elemento;
		W83bXmlElement subElemento;
		String sAux;*/

		//W83bXmlElement elementoValidation =
		// root.getChildElement("Procedure");
//		String familyID = W83bUtilXml.getStringValue(root, "familyId");
		String procedureName = root.getXmlElement("procedureName/description")
				.getStringText(true);
		W83bLocaleString procedureNameLocale = null;
		if (procedureName != null && !procedureName.equals(""))
		{	procedureNameLocale = W83bLocaleStringXML
					.getLocaleString(procedureName);}
		String departmentId = W83bUtilXml.getStringValue(root, "departmentId");
		String departmentName = root
				.getXmlElement("departmentName/description")
				.getStringText(true);
		W83bLocaleString departmentNameLocale = W83bLocaleStringXML
				.getLocaleString(departmentName);
		String managingUnitId = W83bUtilXml.getStringValue(root,
				"organInfo/managingUnitId");
		String managingUnitName = root.getXmlElement(
				"organInfo/managingUnitName/description").getStringText(true);
		W83bLocaleString managingUnitNameLocale = null;
		if (managingUnitName != null && !managingUnitName.equals(""))
		{	managingUnitNameLocale = W83bLocaleStringXML
					.getLocaleString(managingUnitName);}
		String familyName = root.getXmlElement("familyName/description")
				.getStringText(true);
		;
		W83bLocaleString familyNameLocale = null;
		if (familyName != null && !familyName.equals(""))
		{	familyNameLocale = W83bLocaleStringXML.getLocaleString(familyName);}

		procedureCtx = new W83bConsultationContext(familyNameLocale,
				managingUnitId, departmentId, procedureNameLocale,
				departmentNameLocale, managingUnitNameLocale);
		return procedureCtx;
	}

	public W83bConsultationContext getProcedureDataAll() throws W83bException,
			W83bXmlException, ParseException {

		W83bXmlElement root = xmlDocument.getRootElement();
	/*	W83bXmlElement elemento;
		W83bXmlElement subElemento;
		String sAux;*/

		//W83bXmlElement elementoValidation = root.getChildElement("Procedure");
		String procedureId = W83bUtilXml.getStringValue(root,
				"procedureId");
		
		/*String procedureName = W83bUtilXml.getStringValue(root,
		"procedureName/description");*/

		String procedureName = root.getXmlElement(
				"procedureName/description").getStringText(true);
		W83bLocaleString procedureNameLocale = null;
		if (procedureName != null && !procedureName.equals(""))
			procedureNameLocale = W83bLocaleStringXML
					.getLocaleString(procedureName);

		
		
		String departmentId = W83bUtilXml.getStringValue(root,
				"departmentId");
		String departmentName = root.getXmlElement(
				"departmentName/description").getStringText(true);
		W83bLocaleString departmentNameLocale = null;
		if (departmentName != null && !departmentName.equals(""))
		{	departmentNameLocale = W83bLocaleStringXML
					.getLocaleString(departmentName);}

		String entityCode = W83bUtilXml.getStringValue(root,
				"entityCode");

		String managingUnitId = W83bUtilXml.getStringValue(root,
		"managingUnitId");
		/*String managingUnitFunction = W83bUtilXml.getStringValue(
				elementoValidation, "managingUnitFunction");
		String managingUnitDeliveryKeyFunction = W83bUtilXml.getStringValue(
				elementoValidation, "managingUnitDeliveryKeyFunction");
*/
		String managingUnitName = root.getXmlElement(
				"managingUnitName/description").getStringText(true);
		W83bLocaleString managingUnitNameLocale = null;
		if (managingUnitName != null && !managingUnitName.equals(""))
		{	managingUnitNameLocale = W83bLocaleStringXML
					.getLocaleString(managingUnitName);}
/*
		String familyID = W83bUtilXml.getStringValue(elementoValidation,
				"FamilyId");

		String procedureInboxID = W83bUtilXml.getStringValue(
				elementoValidation, "ProcedureInboxId");
		String procedureInboxName = W83bUtilXml.getStringValue(
				elementoValidation, "ProcedureInboxName ");

		String certifiedValidationMode = W83bUtilXml.getStringValue(
				elementoValidation, "certifiedValidationMode");
		String telematicsCode = W83bUtilXml.getStringValue(elementoValidation,
				"telematicscode");
		String managingUnitInBoxID = W83bUtilXml.getStringValue(
				elementoValidation, "managingUnitInboxId");

		//20Septiembre
		W83bXmlElement telematicElement = root
				.getChildElement("TelematicAction");
		String telematicActionId = W83bUtilXml.getStringValue(telematicElement,
				"telematicActionId");
		String telematicActionName = telematicElement.getXmlElement(
				"telematicActionName/description").getStringText(true);
		W83bLocaleString telematicActionNameLocale = W83bLocaleStringXML
				.getLocaleString(telematicActionName);
		*/
		//adaptacion platea v2.1
		W83bXmlElement documentalSerieElement = null;
		String documentalSerie01Id = "";
		String documentalSerie20Id = "";
		String documentalSerie48Id = "";
		
		if(root.getChildElement("daDocumentalSeries01")!=null){
			documentalSerieElement=	root.getChildElement("daDocumentalSeries01");
			documentalSerie01Id=W83bUtilXml.getStringValue(documentalSerieElement,"ID");
		}
		if(root.getChildElement("daDocumentalSeries20")!=null){
			documentalSerieElement = root.getChildElement("daDocumentalSeries20");
			documentalSerie20Id=W83bUtilXml.getStringValue(documentalSerieElement,"ID");
		}
		if(root.getChildElement("daDocumentalSeries48")!=null){
			documentalSerieElement = root.getChildElement("daDocumentalSeries48");
			documentalSerie48Id=W83bUtilXml.getStringValue(documentalSerieElement,"ID");	
		}
		
		String daProcedureId = W83bUtilXml.getStringValue(root,
		"daProcedureID");
		
		procedureCtx = new W83bConsultationContext(procedureId,
				procedureNameLocale, entityCode, departmentId,
				departmentNameLocale, managingUnitId, managingUnitNameLocale,
				/*managingUnitFunction, managingUnitDeliveryKeyFunction,
				familyID, procedureInboxID, procedureInboxName,
				certifiedValidationMode, telematicsCode, entityNameLocale,
				managingUnitInBoxID, telematicActionId,
				telematicActionNameLocale, */
				documentalSerie01Id, documentalSerie20Id, documentalSerie48Id,daProcedureId);

		return procedureCtx;
	}

	//private R02DProcedure procedure;
	private W83bConsultationContext procedureCtx;

	private W83bXmlDocument xmlDocument;

//	private static Logger log = Logger
//			.getLogger(W83bConsultationContextParser.class.getName());
}